<?php
// common.php 파일을 포함시켜 기본 환경 구성을 로드합니다.
include_once('./_common.php');

// 비밀번호를 처리하기 위한 암호화 함수가 필요합니다.
// 입력받은 비밀번호를 암호화합니다.
$password = get_encrypt_string('비밀번호');

// 게시글 작성 함수
function write_board($bo_table, $subject, $content, $link, $media, $pub_date, $mb_id, $nickname, $password) {
    global $g5;

    // 게시판 테이블 확인
    $board_table = $g5['board_table'];
    $sql = "SELECT bo_table FROM {$board_table} WHERE bo_table = '{$bo_table}'";
    $result = sql_fetch($sql);
    if (!$result) {
        echo "게시판 ID가 존재하지 않습니다.";
        return false;
    }

    $subject = sql_real_escape_string($subject);
    $content = sql_real_escape_string($content);
    $link = sql_real_escape_string($link);
    $media = sql_real_escape_string($media);
    $pub_date = sql_real_escape_string($pub_date);
    $mb_id = sql_real_escape_string($mb_id);
    $nickname = sql_real_escape_string($nickname);

    $write_table = $g5['write_prefix'] . $bo_table;

    $sql = " SELECT MAX(wr_num) as max_wr_num FROM `$write_table` ";
    $row = sql_fetch($sql);
    $wr_num = ($row && $row['max_wr_num']) ? $row['max_wr_num'] - 1 : 0;

    //시글 DB에 추가
    $sql = " INSERT INTO `$write_table`
                SET wr_num = '{$wr_num}',
                    wr_reply = '',
                    wr_comment = 0,
                    ca_name = '',
                    wr_option = '2',
                    wr_subject = '{$subject}',
                    wr_content = '{$content}',
                    wr_link1 = '{$link}',
                    wr_link2 = '{$media}',
                    wr_hit = 0,
                    wr_good = 0,
                    wr_nogood = 0,
                    mb_id = '{$mb_id}',
                    wr_password = '{$password}',
                    wr_name = '{$nickname}',
                    wr_email = '',
                    wr_datetime = '".G5_TIME_YMDHIS."',
                    wr_last = '".G5_TIME_YMDHIS."',
                    wr_ip = '".$_SERVER['REMOTE_ADDR']."',
                    wr_1 = '',
                    wr_2 = '',
                    wr_3 = '',
                    wr_4 = '',
                    wr_5 = '';
            ";
    sql_query($sql);
    $wr_id = sql_insert_id();

    $sql = " UPDATE `$write_table` SET wr_parent = '{$wr_id}' WHERE wr_id = '{$wr_id}' ";
    sql_query($sql);

    $sql = " INSERT INTO `{$g5['board_new_table']}`
                SET bo_table = '{$bo_table}',
                    wr_id = '{$wr_id}',
                    wr_parent = '{$wr_id}',
                    bn_datetime = '".G5_TIME_YMDHIS."',
                    mb_id = '{$mb_id}' ";
    sql_query($sql);
    
    $sql = " UPDATE `{$g5['board_table']}`
                SET bo_count_write = bo_count_write + 1
                WHERE bo_table = '{$bo_table}' ";
    sql_query($sql);

    return $wr_id;
}

// HTML 태그와 CSS 스타일 요소 제거하는 함수
function strip_html_css($content) {
    // HTML 태그 제거
    $content = preg_replace('/<[^>]*>/', '', $content);
    // CSS 스타일 요소 제거
    $content = preg_replace('/<style[^>]*>.*<\/style>/is', '', $content);
    return $content;
}
function validate_domain($url) {
    $pattern = '/^(https?:\/\/)?(www\.rfa\.org\/)/i';
    $pattern_check = preg_match($pattern, $url);
    $pattern_check_2 = preg_match('/^(https?:\/\/)?(www\.rfa\.org\/)/i', $url);
    return $pattern_check && $pattern_check_2;
}check;

$bo_table = '게시판아이디'; // 존재하는 게시판 테이블 ID 설정
$mb_id = '닉네임'; // 존재하는 게시글 작성자 ID 설정
$nickname = '닉네임'; // 게시글 작성자 닉네임 설정

//한국어 https://www.rfa.org/korean/in_focus/rss2.xml
//북한(영문) https://www.rfa.org/english/news/north_korea_news/rss2.xml
//중국(영문) https://www.rfa.org/english/news/chinese-news/rss2.xml
//티베트(영문) https://www.rfa.org/english/news/tibet-news/rss2.xml
//영어 https://www.rfa.org/english/rss2.xml
// 자유아시아방송에서 데이터 가져오기 - 자유아시아방송 rss만 사용 가능
$url = 'https://www.rfa.org/english/news/chinese-news/rss2.xml';

if (!validate_domain($url)) {
    echo "유효한 도메인이 아닙니다.";
    exit;
}

$data = file_get_contents($url);
$data = simplexml_load_string($data);

// 게시글 작성
foreach ($data->channel->item as $item) {
    $subject = $item->title;
    $content = $item->description;
    $link = $item->link;
    $media = ''; // 미디어 URL 초기화
    $pub_date = $item->pubDate; // pubDate 가져오기

    // pubDate를 현재 날짜와 비교하여 필터링
    $today = date('Y-m-d');
    $item_date = date('Y-m-d', strtotime($pub_date));
    if ($item_date !== $today) {
        continue; // 오늘 날짜와 다른 경우 건너뜁니다.
    }

    // 미디어 콘텐츠 가져오기
    if ($item->children('media', true)->content) {
        $media = (string)$item->children('media', true)->content->attributes()['url'];
    }

    // HTML 태그와 CSS 스타일 요소 제거
    $subject = strip_html_css($subject);
    $content = strip_html_css($content);

    // 미디어 요소를 img 태그로 변환
    $media_html = '';
    if ($media) {
        $media_html = "<center><img src=\"{$media}\" title=\"{$subject}\" style='width:100%;max-width:400px;height:auto;'></center>";
    }

    // 콘텐츠 안의 텍스트 가져오기
    $content_text = strip_tags($item->children('content', true)->encoded);

    // pubDate를 최상단에 위치하도록 수정
    $content_with_media = $pub_date . "<br>" . $media_html . "<br>" . $content_text . "<br>" . $content_text . "<br>" . "<center>자유아시아방송 제공 및 저작권 소유 | RFA provided and copyrighted -<a href='http://www.rfa.org'>www.rfa.org</a></center>";

    $wr_id = write_board($bo_table, $subject, $content_with_media, $link, $media, $pub_date, $mb_id, $nickname, $password);
    if ($wr_id > 0) {
        echo "게시글이 정상적으로 등록되었습니다. 👍<br>";
        echo "제목: {$subject}<br>";
        echo "링크: <a href=\"{$link}\">{$link}</a><br>";
        if ($media) {
            echo "미디어 첨부: {$media_html}<br>";
        }
        echo "작성일: {$pub_date}<br>";
    } else {
        echo "게시글 등록에 실패하였습니다. 😥<br>";
    }
}
?>